<?php

namespace WTS_EAE\Modules\ProgressBar\Skins;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;


class Skin_3 extends Skin_Base {

	protected function _register_controls_actions() {
		parent::_register_controls_actions(); // TODO: Change the autogenerated stub
		add_action(
			'elementor/element/eae-progress-bar/skin3_general_style/before_section_end',
			[
				$this,
				'extra_controls_add',
			]
		);
	}

	public function get_id() {
		return 'skin3';
	}

	public function get_title() {
		return __( 'Skin 3', 'wts-eae' );
	}

	public function extra_controls_add() {
		$this->update_control(
			'progress_color',
			[
				'default'   => '#50dded',
				'selectors' => [
					'{{WRAPPER}} .eae-pb-bar-inner'        => 'background-color: {{VALUE}};',
					'{{WRAPPER}} .eae-pb-bar-value'        => 'background-color: {{VALUE}};',
					'{{WRAPPER}} .eae-pb-bar-value::after' => 'border-color: {{VALUE}} transparent transparent transparent;',
				],
			]
		);
	}

	public function render() {
		$this->common_render();
	}
}
